import javax.swing.*;
import java.util.ArrayList;
import java.util.Vector;
import java.net.URL;
import java.awt.*;
import java.awt.event.*;
import java.applet.Applet; 
import javax.swing.tree.*;
import javax.swing.event.*;
import javax.swing.filechooser.FileFilter;
import java.io.*;

public class SemaTree extends Applet{

public String getAppletInfo()
{
return "Semantic Tree - Author J.Knabe, jknabe@panmental.de - 23.10.2003 - Source available at http://panmental.de";
}

public final int textareaWidth=50;
public boolean inBrowser=true;
public JTree tree;
public JScrollPane nodeInfo;
public JScrollPane treeview;
public JTextField askField;
public JLabel answerLabel;
public JPanel DefaultInfo;
DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();

public void start(){
}

public void asked(String what){
Object[] o=roots.toArray();
String result="I don't think so.";
String temp=null;
for(int x=0;x<o.length;x++){
  temp=((frame)o[x]).reason(what.toUpperCase(),what.toUpperCase());
  if(!temp.equals("?"))
    result=temp;
  }
answerLabel.setText(result.toUpperCase());
if(!inBrowser)
  System.out.println(result.toUpperCase());
else
  showStatus(result.toUpperCase());
}

public void init(boolean inBrowser){
this.inBrowser=inBrowser;
init();
}

private ArrayList roots;
private JFileChooser file;

//recursively constructs the tree on basis of the underlying
//concept/instances structure
private DefaultMutableTreeNode createNodes(DefaultMutableTreeNode top) {
concept temp=(concept) top.getUserObject();
Object[] sub=temp.has_subclass.toArray();
if((sub!=null)&&sub.length>0)
  for(int x=0;x<sub.length;x++)
    top.add(createNodes(new DefaultMutableTreeNode(sub[x],true)));
Object[] inst=temp.instances.toArray();
if((inst!=null)&&inst.length>0)
  for(int x=0;x<inst.length;x++)
    top.add(new DefaultMutableTreeNode(inst[x],false));
return top;
}

//updates the shown tree with the data present in the roots ArrayList
public void updateTree(){
DefaultMutableTreeNode root=new DefaultMutableTreeNode("universe");
Object[] o=roots.toArray();
for(int x=0;x<o.length;x++){
  DefaultMutableTreeNode top = new DefaultMutableTreeNode(o[x],true);
  root.add(createNodes(top));
  }
final JTree tree = new JTree(root,true);
tree.setRootVisible(false);
tree.setRowHeight(18);
tree.getSelectionModel().setSelectionMode
               (TreeSelectionModel.SINGLE_TREE_SELECTION);
tree.setCellRenderer(renderer);
final SemaTree ref=this;
        tree.addTreeSelectionListener(new TreeSelectionListener() {
            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                                   tree.getLastSelectedPathComponent();
                boolean error=false;
                frame nodeFrame = null;
                if (node == null) error=true;
                else{
                 try{
                    nodeFrame=(frame)node.getUserObject(); 
                  }catch(ClassCastException e2){error=true;}
                 }
                if(error){
                  nodeInfo.setViewportView(new JScrollPane(DefaultInfo));
                  nodeInfo.revalidate();
                  }
                else{
                  nodeInfo.setViewportView(nodeFrame.display(ref));
                  nodeInfo.revalidate();
                  }
            }
        });
treeview.setViewportView(tree);
treeview.revalidate();
}

public void load(){
    int returnVal = file.showOpenDialog(this);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
try{
      BufferedReader datei=new BufferedReader(new FileReader(file.getSelectedFile()));
      roots=new ArrayList();
      while(datei.ready()){
        ListToken input=new ListToken(datei.readLine());
        if((input!=null)&&(input.isList())&&(!input.isEmpty()))
          roots.add(new concept(input));
        }
      updateTree();
      datei.close();
}catch(IOException e){JOptionPane.showMessageDialog(this,"Could not load from file! "+e,"ERROR",JOptionPane.ERROR_MESSAGE);System.err.println("e");}
      }
                  nodeInfo.setViewportView(new JScrollPane(DefaultInfo));
                  nodeInfo.revalidate();
}

public void save(){
   int returnVal = file.showSaveDialog(this);
    if(returnVal == JFileChooser.APPROVE_OPTION) {
try{
      BufferedWriter datei=new BufferedWriter(new FileWriter(file.getSelectedFile(),false));
      Object[] o=roots.toArray();
      for(int x=0;x<o.length;x++){
         datei.write(((concept)o[x]).StringRep());
         datei.newLine();
         }
      datei.close();
}catch(IOException e){JOptionPane.showMessageDialog(this,"Could not write to file! "+e,"ERROR",JOptionPane.ERROR_MESSAGE);}
      }
                  nodeInfo.setViewportView(new JScrollPane(DefaultInfo));
                  nodeInfo.revalidate();
}

public void newRootNode(){
String input=JOptionPane.showInputDialog(this,"What should the name be?");
roots.add(new concept(input));
updateTree();
}

public void init() { 
roots=new ArrayList();

DefaultInfo=new JPanel(new java.awt.GridLayout(1,1));
JTextArea InfoText;
if(inBrowser){
  InfoText=new JTextArea("Welcome to the graphical Interface of this simple Semantic Tree\r\n"+
                          "Application. It allows you to represent connected knowledge in\r\n"+
                          "a hierarchical way and do some simple reasoning. The comfortable\r\n"+
                          "way to get the system working is by just loading a model (.st) file\r\n"+
                          "Since you run this application in a browser file access is not\r\n"+
                          "possible! Instead you get the \"animal\" node from my homework :-)\r\n"+
                          "To type in a representation yourself click on \"new Root\" for a\r\n"+
                          "basic concept (e.g. Animal) and then click on the created root node\r\n"+
                          "to add sub concepts, instances and feature/value-slots.\r\n"+
                          "Subclasses and Instances inherit all the slots of their parent\r\n"+
                          "nodes unless they overwrite them by having a slot with the same\r\n"+
                          "feature name but a different value.\r\n"+
                          "You can ask the system questions in normal english, although it is\r\n"+
                          "not very tolerant... Some example questions:\r\n"+
                          "   Is myCanary an animal?\r\n"+
                          "   Can canary fly?\r\n"+
                          "   What is the color of  canary.\r\n"+
                          "   Can ostrich fly?\r\n"+
                          "   Have ostrich wings?\r\n"+
                          "   Is ostrich dangerous?\r\n"+
                          "   What are the subclasses of fish?\r\n"+
                          "   What are the instances of animal?",10,textareaWidth);
        ListToken animal=new ListToken("[Animal,[[Move,-],[Has_skin,Yes]],[[Fish,[[Move,swim],[Has_grill,Yes]],[[Shark,[[Move,swim],[Is_dangerous,Yes]],[],[[white_Shark,[]]]],[Salmon,[[Is-edible,yes]],[],[]]],[]],[Bird,[[Move,fly],[Has_wings,Yes]],[[Canary,[[Has_color,yellow]],[],[[canary1234,[]],[myCanary,[]]]],[Ostrich,[[Move,walk],[Is-tall,yes]],[],[]]],[]]],[]]");
        roots.add(new concept(animal));
}
else
  InfoText=new JTextArea("Welcome to the graphical Interface of this simple Semantic Tree\r\n"+
                          "Application. It allows you to represent connected knowledge in\r\n"+
                          "a hierarchical way and do some simple reasoning. The comfortable\r\n"+
                          "way to get the system working is by just loading a model (.st) file\r\n"+
                          "To type in a representation yourself click on \"new Root\" for a\r\n"+
                          "basic concept (e.g. Animal) and then click on the created root node\r\n"+
                          "to add sub concepts, instances and feature/value-slots.\r\n"+
                          "Subclasses and Instances inherit all the slots of their parent\r\n"+
                          "nodes unless they overwrite them by having a slot with the same\r\n"+
                          "feature name but a different value.\r\n"+
                          "You can ask the system questions in normal english, although it is\r\n"+
                          "not very tolerant... Some example questions (for animals.st):\r\n"+
                          "   Is myCanary an animal?\r\n"+
                          "   Are ostrich birds?\r\n"+
                          "   Can canary fly?\r\n"+
                          "   What is the color of  canary.\r\n"+
                          "   Can ostrich fly?\r\n"+
                          "   Have ostrich wings?\r\n"+
                          "   Is ostrich dangerous?\r\n"+
                          "   What are the subclasses of fish?\r\n"+
                          "   What are the instances of animal?",10,textareaWidth);
InfoText.setEditable(false);
DefaultInfo.add(InfoText);

nodeInfo=new JScrollPane(DefaultInfo);
tree = new JTree();
if(!inBrowser){
    file = new JFileChooser();
    file.setFileFilter(new FileFilter(){
     public boolean accept(File f){
       return (f.getName().endsWith(".st")||f.isDirectory());
       }
     public String getDescription(){
       return("Semantic Tree files (*.st)");
       }
     });
   }
askField=new JTextField();
answerLabel=new JLabel();

if(inBrowser)
try{
DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
renderer.setLeafIcon(new ImageIcon(getImage(getCodeBase(),"leaf.gif")));
renderer.setOpenIcon(new ImageIcon(new URL(getCodeBase(),"nodeOpen.gif")));
renderer.setClosedIcon(new ImageIcon(new URL(getCodeBase()+"nodeClosed.gif")));
}catch(Exception e){System.err.println("Could not load the node images");}
else
{
renderer.setLeafIcon(new ImageIcon("leaf.gif"));
renderer.setOpenIcon(new ImageIcon("nodeOpen.gif"));
renderer.setClosedIcon(new ImageIcon("nodeClosed.gif"));
}
treeview = new JScrollPane();
treeview.setMinimumSize(new Dimension(150,400));
updateTree();


JPanel control=new JPanel(new GridLayout(4,1));
control.add(askField);
JButton askNow=new JButton("ask above question to the Tree");
askNow.addActionListener(new ActionListener(){
   public void actionPerformed(ActionEvent e){
     asked(askField.getText());
     }
   });
control.add(askNow);
control.add(new JScrollPane(answerLabel));

JPanel buttons=new JPanel(new GridLayout(1,3));
JButton makeRoot=new JButton("new Root");
makeRoot.addActionListener(new ActionListener(){
   public void actionPerformed(ActionEvent e){
     newRootNode();
     }
   });
buttons.add(makeRoot);

JButton loadFile=new JButton("Load tree");
loadFile.addActionListener(new ActionListener(){
   public void actionPerformed(ActionEvent e){
     load();
     }
   });
if(inBrowser)
  loadFile.setEnabled(false);
buttons.add(loadFile);

JButton saveFile=new JButton("Save tree");
saveFile.addActionListener(new ActionListener(){
   public void actionPerformed(ActionEvent e){
     save();
     }
   });
if(inBrowser)
  saveFile.setEnabled(false);
buttons.add(saveFile);

control.add(buttons);
control.setMinimumSize(new Dimension(200,80));
control.setMaximumSize(new Dimension(200,100));
nodeInfo.setMinimumSize(new Dimension(200,200));
nodeInfo.setMaximumSize(new Dimension(200,300));

        JSplitPane infoPane = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
infoPane.setDividerLocation(250);

        infoPane.setTopComponent(nodeInfo);
        infoPane.setBottomComponent(control);
infoPane.setMinimumSize(new Dimension(200,280));
infoPane.setMaximumSize(new Dimension(500,400));

        JSplitPane splitPane = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
        splitPane.setLeftComponent(treeview);
        splitPane.setRightComponent(infoPane);
splitPane.setDividerLocation(150);
add(splitPane, BorderLayout.CENTER);
} 

public static void main(String[] argv){
new AppletFrame("Semantic Tree, Graphical Interface",new SemaTree(),640,480);
}

}

class AppletFrame extends JFrame {

private SemaTree display;

AppletFrame(String title, SemaTree applet, int width, int height){
  super(title);
  display=applet;
  applet.init(false);
  this.getContentPane().add(applet);
  this.setSize(width,height);
  this.pack();
  applet.setVisible(true);
  this.show();
  addWindowListener(
      new WindowAdapter() {  // close the window when the user clicks its close box
          public void windowClosing(WindowEvent evt) {
          close();
          }
      });
}

public void close(){
   System.exit(0);
   }

}
