import javax.swing.*;
import java.util.ArrayList;

public class concept extends frame{

public final boolean debug=false;

public concept(String name){
super(name);
has_subclass=new ArrayList();
instances=new ArrayList();
}

//for loading a structure from file
//expects Prolog-like List in the form:
//[name,[[feat1,val1],...,[feat_n,val_n]],[[Subclass_1],...,[Subclass_n]],[[Instance_1],...,[Instance_n]]]
//where of course [Subclass_i] and [Instance_i] is again a complex list
public concept(ListToken in){
this(in.head().getMe());
getSlotList(in.tail().head());
getSubclassList(in.tail().tail().head());
getInstancesList(in.tail().tail().tail().head());
}

public void getSubclassList(ListToken in){
if(in==null) return;
if(!in.isList()) return;
if(in.isEmpty()) return;
ListToken Subclass=in.head();
addSubclass(new concept(Subclass));
getSubclassList(in.tail());
}

public void getInstancesList(ListToken in){
if(in==null) return;
if(!in.isList()) return;
if(in.isEmpty()) return;
ListToken Inst=in.head();
addInstance(new object(Inst));
getInstancesList(in.tail());
}

public ArrayList has_subclass; //May have several subclass or none
public ArrayList instances; //May have several instances or none

public String subReason2(String particle,String question, String org){
//check for stuff like: "Is Shark a Fish?"
if(question.indexOf(particle)!=-1){
  question=question.replaceAll("\\s"+particle+"\\s"," ");
  String[] words=question.split("\\s+");
  ArrayList inst=getAllInst();
  ArrayList subc=getAllSub();
  for(int x=0;x<words.length;x++){
    if(subc.contains(new frame(words[x]))){
      return words[x]+" is a subclass of "+name+".";
      }
    if(inst.contains(new frame(words[x]))){
      return words[x]+" is an instance of "+name+".";
      }
    }
  }
return null;
} 

public String reason(String question,String org){
String result="?";
if((result=super.reason(question,org))!="?")
  return result;
else
  {//check for:
   //(1)   What are the subclasses of Canary
   //(2)   What are the instances of animal?
if(question.indexOf(name.toUpperCase())!=-1) //your name is mentioned!
  {
question=question.replaceAll("[?,.!]"," ");
question=question.replaceAll("\\s"+name.toUpperCase()+"\\s"," "); 
        //remove "fill stuff":
question=question.replaceAll("\\sTHE\\s"," ");
question=question.replaceAll("\\sWHAT\\s"," ");
String answer=null;
answer=subReason2("HAS",question,org);
if(answer!=null)
  return answer;
answer=subReason2("HAVE",question,org);
if(answer!=null)
  return answer;
answer=subReason2("IS",question,org);
if(answer!=null)
  return answer;
answer=subReason2("ARE",question,org);
if(answer!=null)
  return answer;
answer=subReason2("CAN",question,org);
if(answer!=null)
  return answer;
 if(question.indexOf("INSTANCE")!=-1){
   answer="All the instances of "+name+" are: ["; 
   Object[] o2=getAllInst().toArray();
   for(int x=0;x<o2.length-1;x++){
     if(((object)o2[x]).myParent.name!=name)
       answer=answer.concat(o2[x]+" (is a "+((object)o2[x]).myParent.name+"),");
     else
       answer=answer.concat(o2[x]+",");
     }
   if(((object)o2[o2.length-1]).myParent.name!=name)
     answer=answer.concat(o2[o2.length-1]+" (is a "+((object)o2[o2.length-1]).myParent.name+")");
   else
     answer=answer.concat(o2[o2.length-1]+"");
   return answer.concat("]");
   }
 if(question.indexOf("SUBCLASS")!=-1){
   answer="The direct subclasses of "+name+" are: ["; 
   Object[] o2=has_subclass.toArray();
   for(int x=0;x<o2.length-1;x++)
     answer=answer.concat(o2[x]+",");
   return answer.concat(o2[o2.length-1]+"]");
   }
  return "?";  //name mentioned but we couldn't find anything - forget it
  }
if(debug) System.out.println("debug: nothing found in "+name+", going deeper.");
   //try Instances:
  Object[] o=instances.toArray();
  for(int x=0;x<o.length;x++){
    result=((frame)o[x]).reason(question,org);
    if(!result.equals("?"))
      return result;
    }
   //try SubClasses:
  Object[] o2=has_subclass.toArray();
  for(int x=0;x<o2.length;x++){
    result=((frame)o2[x]).reason(question,org);
    if(!result.equals("?"))
      return result;
    }
  }
return "?";
}

//finds all instances, especially those of subclasses
public ArrayList getAllInst(){
ArrayList temp=(ArrayList) instances.clone();
Object[] sub=has_subclass.toArray();
for(int x=0;x<sub.length;x++){
  temp.addAll(((concept)sub[x]).getAllInst());
  }
return(temp);
}

//finds all instances, especially those of subclasses
public ArrayList getAllSub(){
ArrayList temp=(ArrayList) has_subclass.clone();
Object[] sub=has_subclass.toArray();
for(int x=0;x<sub.length;x++){
  temp.addAll(((concept)sub[x]).getAllSub());
  }
return(temp);
}

public void setSuperClass(concept mother){
myParent=mother;
if(!mother.has_subclass.contains(this))
  mother.has_subclass.add(this);
}

public void addSubclass(frame child){
child.myParent=this; //no multiple inheritance
if(!has_subclass.contains(child))
  has_subclass.add(child);
}

public void addInstance(frame instance){
instance.myParent=this; //no multiple inheritance
if(!instances.contains(instance))
  instances.add(instance);
}

public String SubclassRep(){
if(has_subclass.isEmpty())
  return "[]";
Object[] o =has_subclass.toArray();
String result="[";
for(int x=0;x<o.length-1;x++)
  result=result.concat(((concept)o[x]).StringRep()+",");
result=result.concat(((concept)o[o.length-1]).StringRep());
return result.concat("]");
}

public String InstancesRep(){
if(instances.isEmpty())
  return "[]";
Object[] o =instances.toArray();
String result="[";
for(int x=0;x<o.length-1;x++)
  result=result.concat(((object)o[x]).StringRep()+",");
result=result.concat(((object)o[o.length-1]).StringRep());
return result.concat("]");
}

//String representation for writing to files
public String StringRep(){
return "["+name+","+super.StringRep()+","+SubclassRep()+","+InstancesRep()+"]";
}

private SemaTree holder=null;

private void update(){
if(holder!=null){
  holder.nodeInfo.setViewportView(display(holder));
  holder.nodeInfo.revalidate();
  }
}

private void updateTree(){
if(holder!=null){
  holder.updateTree();
  }
}

public void addSlotClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter slot in the form \"feature:value\"");
     if((featAndVal!=null)&&(featAndVal.indexOf(':')==-1))
       JOptionPane.showMessageDialog(holder,"Wrong format - please try again!");
     else
       addSlot(featAndVal);
update();
}

public void addSubClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter name of new subclass");
     if(featAndVal!=null){
       addSubclass(new concept(featAndVal));
       updateTree();
       }
}

public void addInstClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter name of new instance");
     if(featAndVal!=null){
       addInstance(new object(featAndVal));
       updateTree();
       }
}

public void renameClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter new name",name);
     if(featAndVal!=null)
       changeName(featAndVal);
update();
}

//represent yourself, including the edit options
public JPanel display(SemaTree holder){
this.holder=holder;   //remember showing Panel for update events
JPanel temp=new JPanel(new java.awt.GridLayout(2,1));
JTextArea slotText=new JTextArea(getStringSlots(),5,holder.textareaWidth);
slotText.setEditable(false);
temp.add(slotText);
JPanel Buttons=new JPanel(new java.awt.GridLayout(4,1));

JButton nameButton=new JButton("rename me");
nameButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     renameClicked();
     }
   });
Buttons.add(nameButton);

JButton featButton=new JButton("add/change/overwrite feature");
featButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     addSlotClicked();
     }
   });
Buttons.add(featButton);

JButton subButton=new JButton("add subclass");
subButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     addSubClicked();
     }
   });
Buttons.add(subButton);

JButton instButton=new JButton("add instance");
instButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     addInstClicked();
     }
   });
Buttons.add(instButton);

temp.add(Buttons);
return temp;
}

}
