//general class, providing the common frame for concepts and objects
//This is good in order to be able to treat them equal.
import javax.swing.*;
import java.util.ArrayList;

public class frame{

protected String name;
protected ArrayList slots;//contains attributes
protected frame myParent=null;   //exactly one or null for root

public frame(String name){
this.name=name;
slots=new ArrayList();
}

public void changeName(String newname){
if(!slots.isEmpty()){
  Object[] s=slots.toArray();
  for(int x=0;x<s.length;x++)
    ((attrib)s[x]).setOwner(newname);
  }
name=newname;
}

//outputs all the _own_ (not inherited) slots as 
//one String (similar to a Prolog List), used for writing to file.
public String StringRep(){
if(slots.isEmpty())
  return "[]";
Object[] s=slots.toArray();
String result="[";
for(int x=0;x<s.length-1;x++)
  result=result.concat("["+((attrib)s[x]).getFeature()+","+((attrib)s[x]).getVal()+"],");
result=result.concat("["+((attrib)s[s.length-1]).getFeature()+","+((attrib)s[s.length-1]).getVal()+"]");
return result.concat("]");
}

//gets a slotlist of the form [[f1,v1],[f2,v2],...,[fn,vn]]
//recursivly works through it and adds the attributes
public void getSlotList(ListToken in){
if(in==null) return;
if(!in.isList()) return;
if(in.isEmpty()) return;
ListToken slot=in.head();
addSlot(slot.head().getMe(),(slot.tail()).head().getMe());
getSlotList(in.tail());
}

//if feature doesn't exist _here_ create and give value
//otherwise change value of existing
public void addSlot(String feature, String value){
attrib temp=new attrib(feature,value,name);
if(!slots.contains(temp))
  slots.add(temp);
else
  ((attrib) slots.get(slots.indexOf(temp))).setVal(value);
}

//for convenience: Input can be in the form "feature:value"
public void addSlot(String featAndVal){
if(featAndVal.indexOf(':')==-1) {System.err.println("Error: Please provide input in the form: \"feature:value\""); return;}
addSlot(featAndVal.substring(0,featAndVal.indexOf(':')),featAndVal.substring(featAndVal.indexOf(':')+1) );
}

//synonym for addSlot
public void changeSlot(String feature, String value){
addSlot(feature,value);
}

//allSlots, including parent ones but excludings doubles 
//(overwriting inheritance, "youngest" value counts)
public ArrayList getAllSlots(){
ArrayList temp=(ArrayList) slots.clone();
if(myParent!=null){
  ArrayList temp2=myParent.getAllSlots();
  while(!temp2.isEmpty()){
    if(!temp.contains(temp2.get(0)))
      temp.add(temp2.get(0));
    temp2.remove(0);
    }
  }
return(temp);
}

public boolean equals(Object x){
if(x instanceof frame)
  return this.name.toUpperCase().equals(((frame)x).name.toUpperCase());
else
  return false;
}

public String subReason(String particle,String question, String org){
attrib result=null;
if(question.indexOf(particle)!=-1){
  question=question.replaceAll("\\s"+particle+"\\s"," ");
  String[] words=question.split("\\s+");
  for(int x=0;x<words.length;x++){
    result=getAttrib(words[x]);
    if(result==null)
      result=getAttrib(particle+"_"+words[x]);
    if(result==null)
      result=getAttrib(particle+"-"+words[x]);
    if(result==null)
      result=getAttrib("is_"+words[x]);
    if(result==null)
      result=getAttrib("is-"+words[x]);
    if(result==null)
      result=getAttrib("has_"+words[x]);
    if(result==null)
      result=getAttrib("has-"+words[x]);
    if(result!=null){
     if((result.getVal().toUpperCase().equals("YES"))||(result.getVal().toUpperCase().equals("NO")))
      {
      String answer=result.getVal()+", "+name+" "+particle+" ";
      if(result.getVal().toUpperCase().equals("NO"))
        answer=answer.concat("not ");
      answer=answer.concat(words[x]+".");
      return answer;
      }
     else
      {
      return "The "+words[x]+" of "+name+" "+particle+" "+result.getVal();
      }
      }
    }
  }
return null;
}

public String reason(String question,String org){
if(question.indexOf(name.toUpperCase())==-1) //if your name is not mentioned forget it
  return "?";
        //remove my name:
question=question.replaceAll("[?,.!]"," ");
question=question.replaceAll("\\s"+name.toUpperCase()+"\\s"," "); 
        //remove "fill stuff":
question=question.replaceAll("\\sTHE\\s"," ");
question=question.replaceAll("\\sWHAT\\s"," ");
String answer=null;
answer=subReason("HAS",question,org);
if(answer!=null)
  return answer;
answer=subReason("HAVE",question,org);
if(answer!=null)
  return answer;
answer=subReason("IS",question,org);
if(answer!=null)
  return answer;
answer=subReason("ARE",question,org);
if(answer!=null)
  return answer;
answer=subReason("CAN",question,org);
if(answer!=null)
  return answer;

Object[] o=getAllSlots().toArray();
for(int x=0;x<o.length;x++){
  if(question.indexOf( ((attrib)o[x]).getVal().toUpperCase() )!=-1){
    return "Yes.";
    }
  }

if(question.indexOf("SLOT")!=-1){
  answer="The slots of "+name+" are: [";
  Object[] o2=getAllSlots().toArray();
  for(int x=0;x<o2.length;x++)
    answer=answer.concat(o2[x]+",");
  return answer.concat("]");
  }
return "?";
}

public String getStringSlots(){
Object[] o=getAllSlots().toArray();
String result="All slots of "+name+":\r\n";
String owner;
for(int x=0;x<o.length;x++){
  owner=((attrib)o[x]).getOwner();
  if(owner==name)
    result=result.concat(o[x]+"\r\n");
  else
    result=result.concat(o[x]+"; inherited from "+owner+"\r\n");
  }
return result;
}

public attrib getAttrib(String feature){
ArrayList temp=getAllSlots();
if((temp!=null)&&(temp.contains(new attrib(feature)))){
  return((attrib)temp.get(temp.indexOf(new attrib(feature))));
  }
return null;
}

public JPanel display(SemaTree holder){
return null;
}

public String toString(){
return name;
}

}
