import javax.swing.*;
import java.util.ArrayList;

public class object extends frame{

public object(String name){
super(name);
}

//for loading a structure from file
//expects Prolog-like List in the form:
//[name, [[feat1,val1],...,[feat_n,val_n]]]
public object(ListToken in){
this(in.head().getMe());
getSlotList(in.tail().head());
}

//String representation for writing to files
public String StringRep(){
return "["+name+","+super.StringRep()+"]";
}

private SemaTree holder=null;

private void update(){
if(holder!=null){
  holder.nodeInfo.setViewportView(display(holder));
  holder.nodeInfo.revalidate();
  }
}

public void addSlotClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter slot in the form \"feature:value\"");
     if(featAndVal.indexOf(':')==-1)
       JOptionPane.showMessageDialog(holder,"Wrong format - please try again!");
     else
       addSlot(featAndVal);
update();
}

public void renameClicked(){
     String featAndVal=JOptionPane.showInputDialog("Please enter new name",name);
     if(featAndVal!=null)
       changeName(featAndVal);
update();
}

//represent yourself, including the edit options
public JPanel display(SemaTree holder){
this.holder=holder;   //remember showing Panel for update events
JPanel temp=new JPanel(new java.awt.GridLayout(2,1));
JTextArea slotText=new JTextArea(getStringSlots(),5,holder.textareaWidth);
slotText.setEditable(false);
temp.add(slotText);
JPanel Buttons=new JPanel(new java.awt.GridLayout(4,1));

JButton nameButton=new JButton("rename me");
nameButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     renameClicked();
     }
   });
Buttons.add(nameButton);

JButton featButton=new JButton("add/change/overwrite feature");
featButton.addActionListener(new java.awt.event.ActionListener(){
   public void actionPerformed(java.awt.event.ActionEvent e){
     addSlotClicked();
     }
   });
Buttons.add(featButton);

temp.add(Buttons);
return temp;
}

}
